@extends("layout.app")
@section("content")
	
		<section class="pt-4">
			<div class="container px-lg-5">
				<div class="row gx-lg-5">
					<div class="col-lg-6 col-12 mb-5">
						<img style="height:300px;width:100%;object-fit:contain;border-radius:1rem" src="{{asset('storage/'.json_decode($product->image)[0]->download_link)}}">
					</div>
					<div class="col-lg-6 col-12 mb-5" style="height:auto;display:grid;align-items:center">
						<h1>{{$product->name}}</h1>
						<p>{{$product->description}}</p>
						<a class="btn btn-dark btn-lg m-2" href="{{asset('storage/'.json_decode($product->file)[0]->download_link)}}" download>Download</a>
					</div>
				</div>
				@if(count($product->extra_fields))
				<center>
					<div class="col-lg-6 col-12 mb-5">
				<table class="table table-bordered table-hover text-center">
				@foreach($product->extra_fields as $data)
					<tr>
						<td ><h4>{{$data->name}}</h4></td>
						<td><a class="btn btn-dark btn-lg m-2" href="{{asset('storage/'.json_decode($product->file)[0]->download_link)}}" download>Download</a></td>
					</tr>
					@endforeach
				</table>
				</div>
				</center>
					
				@endif
				
			</div>
		</section>

@if(count($related_products))
        <!-- Categories-->
        <section class="pt-4">
            <div class="container col-10">
                <!-- Page Features-->
                <div class="row gx-lg-5">
					<div class="col-12 mb-5">
                        <h4 class="display-6 text-center fw-bold">Related Products</h4>
					</div>
					@foreach($related_products as $key => $data2)
					@if($key < 6)
                    <div class="col-lg-6 col-xxl-4 mb-5">
                        <div class="card bg-light border-0 " style="box-shadow:2px 5px 20px rgb(0,0,0,0.2)">
                            <div class="card-body text-center p-2">
                                <div class="bg-light bg-gradient text-white rounded-3">
									<img style="height:300px;object-fit:cover;width:100%;border-radius:0.5rem" src="{{asset('storage/'.json_decode($data2->image)[0]->download_link)}}">
								</div>
                                <h2 class="fs-4 fw-bold">{{$data2->name}}</h2>
                                <p class="mb-0">{{$data2->description}}</p>
								<a class="btn btn-primary btn-lg m-2" href="{{route('product.detail',$data2->slug)}}">View</a>
                            </div>
                        </div>
                    </div>
					@endif
                    @endforeach
					<div class="col-12 mb-5 text-center">
					<a class="btn btn-primary btn-lg m-2" href="{{route('category',$product->category->slug)}}">View More</a>
				
                </div>
                </div>
            </div>
        </section>
@endif
        @endsection
