import * as THREE from "https://cdn.skypack.dev/three@0.129.0/build/three.module.js";
import { OrbitControls } from "https://cdn.skypack.dev/three@0.129.0/examples/jsm/controls/OrbitControls.js";
import { GLTFLoader } from "https://cdn.skypack.dev/three@0.129.0/examples/jsm/loaders/GLTFLoader.js";

const scene = new THREE.Scene();


const camera = new THREE.PerspectiveCamera(30, window.innerWidth / window.innerHeight, 0.1, 1000);

let object;
let controls;
let objToRender = 'box';

let mouseX = window.innerWidth;
let mouseY = window.innerHeight;
let selectedColor = new THREE.Color(0xffffff);

const loader = new GLTFLoader();
loader.load(
	`models/${objToRender}/scene.gltf`,
	function (gltf){
		object = gltf.scene;
		console.log(object.parent);
		scene.add(object);
	},
	function (xhr){
		
	},
	function(error){
		console.log(error);
	}
);

const renderer = new THREE.WebGLRenderer({alpha:true});
renderer.setSize(window.innerWidth,window.innerHeight);
document.getElementById("model").appendChild(renderer.domElement);
camera.position.z = objToRender == "dino" ? 25:500;

const topLight = new THREE.DirectionalLight(0xffffff, 1);
topLight.position.set(255,500,500);
//topLight.castShadow = true;
scene.add(topLight);


const ambientLight = new THREE.AmbientLight(0xffffff, objToRender == "dino" ? 5 : 1);
scene.add(ambientLight);

const color = new THREE.Color("rgb(255,0,0)");
scene.add(color);
scene.isColor=true;

function animate(){
requestAnimationFrame(animate);
	
if(object && objToRender == "box"){
object.rotation.y =  mouseX / window.innerWidth * 3;
object.rotation.x =  mouseY * 2.5 / window.innerHeight;
}
	
renderer.render(scene, camera);
}

window.addEventListener("resize",function(){
	camera.aspect = window.innerWidth / window.innerHeight;
	camera.updateProjectionMatrix();
	renderer.setSize(window.innerWidth, window.innerHeight);
});


document.getElementById("model").onmousemove = (e) => {
mouseX = e.clientX;
mouseY = e.clientY;
}


animate();
